document.addEventListener('DOMContentLoaded', async () => {
  try {
    const response = await fetch('https://ruby.lease/api/reports');
    const reportes = await response.json();
   console.log(reportes)
    const contenedor = document.getElementById('reportes');
    reportes.forEach(reporte => {
      const div = document.createElement('div');
      div.className = 'reporte';
      div.innerHTML = `
        <h3>${reporte.name || 'Sin nombre'}</h3>
        <p>RFC: ${reporte.rfc}</p>
        <p>Estado: ${reporte.valid_ciec}</p>
        <p> ID: ${reporte.id}</p>
        <p> Score: ${reporte.score}</p>
        <p>Porcentaje completado: ${reporte.percentage_complete}</p>
        <p>Creado: ${reporte.created_at}</p>
        <p>Actualizado: ${reporte.updated_at}</p>
      `;
      contenedor.appendChild(div);
    });
  } catch (error) {
    console.error('Error:', error);
  }
});